//
//  CellsViewController.m
//  Cells
//
//  Created by Robert Górczyński on 11-06-29.
//

#import "CellsViewController.h"

@implementation CellsViewController
@synthesize computers;
@synthesize tvCell;

- (void)viewDidLoad { 
	
    NSDictionary *row1 = [[NSDictionary alloc] initWithObjectsAndKeys: 
						  @"MacBook", @"Name", @"biały", @"Color", nil]; 
    NSDictionary *row2 = [[NSDictionary alloc] initWithObjectsAndKeys: 
						  @"MacBook Pro", @"Name", @"srebrny", @"Color", nil]; 
    NSDictionary *row3 = [[NSDictionary alloc] initWithObjectsAndKeys: 
						  @"iMac", @"Name", @"srebrny", @"Color", nil]; 
    NSDictionary *row4 = [[NSDictionary alloc] initWithObjectsAndKeys: 
						  @"Mac Mini", @"Name", @"srebrny", @"Color", nil]; 
    NSDictionary *row5 = [[NSDictionary alloc] initWithObjectsAndKeys: 
						  @"Mac Pro", @"Name", @"srebrny", @"Color", nil]; 
	
    NSArray *array = [[NSArray alloc] initWithObjects:row1, row2, 
                      row3, row4, row5, nil]; 
    self.computers = array; 
	
    [row1 release]; 
    [row2 release]; 
    [row3 release]; 
    [row4 release]; 
    [row5 release]; 
    [array release]; 
} 

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
	self.computers = nil;
    self.tvCell = nil; 
    [super viewDidUnload];
}


- (void)dealloc {
    [computers release];
    [tvCell release]; 
    [super dealloc];
}

#pragma mark - 
#pragma mark Metody źródła danych tabeli
- (NSInteger)tableView:(UITableView *)tableView 
 numberOfRowsInSection:(NSInteger)section { 
    return [self.computers count]; 
} 

- (UITableViewCell *)tableView:(UITableView *)tableView 
         cellForRowAtIndexPath:(NSIndexPath *)indexPath { 
    static NSString *CustomCellIdentifier = @"CustomCellIdentifier"; 
	
    UITableViewCell *cell = [tableView 
							 dequeueReusableCellWithIdentifier: CustomCellIdentifier]; 
    if (cell == nil) { 
        NSArray *nib = [[NSBundle mainBundle] loadNibNamed:@"CustomCell" 
													 owner:self options:nil]; 
        if ([nib count] > 0) { 
            cell = self.tvCell; 
        } else { 
            NSLog(@"Nie udało się wczytać pliku nib!"); 
        }
    } 
    NSUInteger row = [indexPath row]; 
    NSDictionary *rowData = [self.computers objectAtIndex:row]; 
	
    UILabel *colorLabel = (UILabel *)[cell viewWithTag:kNameValueTag]; 
    colorLabel.text = [rowData objectForKey:@"Color"]; 
	
    UILabel *nameLabel = (UILabel *)[cell viewWithTag:kColorValueTag]; 
    nameLabel.text = [rowData objectForKey:@"Name"]; 
    return cell; 
}

@end
